//[BotStacks Chat SDK](../../../index.md)/[ai.botstacks.sdk.state](../index.md)/[Chat](index.md)

# Chat

@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)

class [Chat](index.md)(id: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val kind: [ChatType](../-chat-type/index.md)) : [Pager](../-pager/index.md)&lt;[Message](../-message/index.md)&gt; , [Identifiable](../-identifiable/index.md)

Class that holds information for a given Chat (Group, DM, etc.)

#### Parameters

common

| | |
|---|---|
| id | The identifier for the Chat |
| kind | The kind of Chat |

## Constructors

| | |
|---|---|
| [Chat](-chat.md) | [common]<br>constructor(id: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), kind: [ChatType](../-chat-type/index.md)) |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common]<br>object [Companion](-companion/index.md) |

## Properties

| Name | Summary |
|---|---|
| [_private](_private.md) | [common]<br>var [_private](_private.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [admins](admins.md) | [common]<br>@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)<br>val [admins](admins.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Participant](../-participant/index.md)&gt; |
| [deleting](deleting.md) | [common]<br>var [deleting](deleting.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [description](description.md) | [common]<br>var [description](description.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [displayDescription](display-description.md) | [common]<br>val [displayDescription](display-description.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [displayImage](display-image.md) | [common]<br>val [displayImage](display-image.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [displayName](display-name.md) | [common]<br>val [displayName](display-name.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [editPath](edit-path.md) | [common]<br>val [editPath](edit-path.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [friend](friend.md) | [common]<br>val [friend](friend.md): [User](../-user/index.md)? |
| [image](image.md) | [common]<br>var [image](image.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [invitePath](invite-path.md) | [common]<br>val [invitePath](invite-path.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [invites](invites.md) | [common]<br>val [invites](invites.md): [SnapshotStateList](https://developer.android.com/reference/kotlin/androidx/compose/runtime/snapshots/SnapshotStateList.html)&lt;[User](../-user/index.md)&gt; |
| [inviting](inviting.md) | [common]<br>var [inviting](inviting.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isAdmin](is-admin.md) | [common]<br>val [isAdmin](is-admin.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isDM](is-d-m.md) | [common]<br>val [isDM](is-d-m.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isGroup](is-group.md) | [common]<br>val [isGroup](is-group.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isMember](is-member.md) | [common]<br>val [isMember](is-member.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isUnread](is-unread.md) | [common]<br>val [isUnread](is-unread.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [joining](joining.md) | [common]<br>var [joining](joining.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [kind](kind.md) | [common]<br>val [kind](kind.md): [ChatType](../-chat-type/index.md) |
| [latest](latest.md) | [common]<br>var [latest](latest.md): [Message](../-message/index.md)? |
| [members](members.md) | [common]<br>val [members](members.md): [SnapshotStateList](https://developer.android.com/reference/kotlin/androidx/compose/runtime/snapshots/SnapshotStateList.html)&lt;[Participant](../-participant/index.md)&gt; |
| [membership](membership.md) | [common]<br>val [membership](membership.md): [Participant](../-participant/index.md)? |
| [name](name.md) | [common]<br>var [name](name.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [offlineNotAdminUsers](offline-not-admin-users.md) | [common]<br>@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)<br>val [offlineNotAdminUsers](offline-not-admin-users.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Participant](../-participant/index.md)&gt; |
| [onlineNotAdminUsers](online-not-admin-users.md) | [common]<br>@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)<br>val [onlineNotAdminUsers](online-not-admin-users.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Participant](../-participant/index.md)&gt; |
| [path](path.md) | [common]<br>val [path](path.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [sending](sending.md) | [common]<br>var [sending](sending.md): [SnapshotStateList](https://developer.android.com/reference/kotlin/androidx/compose/runtime/snapshots/SnapshotStateList.html)&lt;[Message](../-message/index.md)&gt; |
| [typingUsers](typing-users.md) | [common]<br>var [typingUsers](typing-users.md): [SnapshotStateList](https://developer.android.com/reference/kotlin/androidx/compose/runtime/snapshots/SnapshotStateList.html)&lt;[User](../-user/index.md)&gt; |
| [unreadCount](unread-count.md) | [common]<br>var [unreadCount](unread-count.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [updating](updating.md) | [common]<br>var [updating](updating.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |

## Functions

| Name | Summary |
|---|---|
| [addMessage](add-message.md) | [common]<br>fun [addMessage](add-message.md)(message: [Message](../-message/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [load](load.md) | [common]<br>open suspend override fun [load](load.md)(skip: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), limit: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Message](../-message/index.md)&gt; |
| [set](set.md) | [common]<br>fun [set](set.md)(notifications: [NotificationSetting](../-notification-setting/index.md), isSync: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) |
